<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model 
{

    protected $table = 'profiles';
    public $timestamps = true;
    protected $guarded = array('note');
    protected $fillable = array('display_name', 'first_name', 'last_name', 'pic', 'gender', 'date_of_birth', 'dob_month', 'dob_day', 'dob_year', 'about_me', 'phone', 'phone_type', 'activated', 'position', 'company', 'website', 'skypeid', 'twitter_username', 'instagram_username', 'facebook_username', 'facebookurl', 'linked_in_url', 'google_plus_url', 'githubid', 'api_key_id');
    protected $visible = array('first_name', 'last_name', 'pic', 'gender', 'date_of_birth', 'dob_month', 'dob_day', 'dob_year', 'about_me', 'phone', 'phone_type', 'activated', 'position', 'company', 'website', 'skypeid', 'twitter_username', 'instagram_username', 'facebook_username', 'facebookurl', 'linked_in_url', 'google_plus_url', 'githubid', 'note', 'api_key_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->withPivot('profile_user');
    }

    public function apiKeys()
    {
        return $this->hasMany('ApiKeys');
    }

    public function PurchasedSoftware()
    {
        return $this->hasMany('App\Models\User');
    }

    public function PurchasedProducts()
    {
        return $this->hasMany('Products');
    }

    public function CustomerOrder()
    {
        return $this->hasMany('Order');
    }

}